<?php
/**
 * Database Setup Script
 * Run this once to create all necessary tables
 */

require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/config/config.php';

try {
    $db = Database::getInstance()->getConnection();
    
    $sql = getSetupSQL();
    $db->exec($sql);
    
    echo "✅ Database tables created successfully!\n\n";
    
    // Create default admin user
    $username = 'admin';
    $email = 'admin@nosyradigital.com.ng';
    $password = 'Admin@123'; // CHANGE THIS IN PRODUCTION
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
    
    $userQuery = "INSERT INTO users (username, email, password, name, role) 
                  VALUES (:username, :email, :password, :name, :role)
                  ON DUPLICATE KEY UPDATE id=id";
    
    $stmt = $db->prepare($userQuery);
    $stmt->execute([
        ':username' => $username,
        ':email' => $email,
        ':password' => $hashedPassword,
        ':name' => 'Administrator',
        ':role' => 'admin'
    ]);
    
    echo "✅ Default admin user created!\n";
    echo "   Username: $username\n";
    echo "   Password: $password\n";
    echo "   ⚠️  IMPORTANT: Change this password immediately!\n\n";
    
    // Create default categories
    $categories = [
        ['name' => 'Technology', 'slug' => 'technology', 'description' => 'Technology and digital innovation'],
        ['name' => 'Design', 'slug' => 'design', 'description' => 'Design trends and inspiration'],
        ['name' => 'Business', 'slug' => 'business', 'description' => 'Business insights and strategies'],
        ['name' => 'Marketing', 'slug' => 'marketing', 'description' => 'Marketing tips and strategies']
    ];
    
    $catQuery = "INSERT INTO categories (name, slug, description) 
                 VALUES (:name, :slug, :description)
                 ON DUPLICATE KEY UPDATE id=id";
    $catStmt = $db->prepare($catQuery);
    
    foreach ($categories as $category) {
        $catStmt->execute($category);
    }
    
    echo "✅ Default categories created!\n\n";
    echo "🎉 Setup complete! Your blog system is ready to use.\n";
    
} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}