<?php
/**
 * Image Upload Route
 */

function uploadImage() {
    $user = JWT::verify();
    
    if (!isset($_FILES['image'])) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'No image file provided'
        ]);
        return;
    }
    
    $file = $_FILES['image'];
    
    // Validate file
    if ($file['error'] !== UPLOAD_ERR_OK) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Upload error occurred'
        ]);
        return;
    }
    
    if ($file['size'] > MAX_FILE_SIZE) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'File size exceeds maximum allowed size'
        ]);
        return;
    }
    
    $finfo = finfo_open(FILEINFO_MIME_TYPE);
    $mimeType = finfo_file($finfo, $file['tmp_name']);
    finfo_close($finfo);
    
    if (!in_array($mimeType, ALLOWED_IMAGE_TYPES)) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Invalid file type. Only images allowed.'
        ]);
        return;
    }
    
    // Generate unique filename
    $extension = pathinfo($file['name'], PATHINFO_EXTENSION);
    $filename = uniqid() . '_' . time() . '.' . $extension;
    
    // Create year/month directory structure
    $yearMonth = date('Y/m');
    $uploadPath = UPLOAD_DIR . '/' . $yearMonth;
    
    if (!file_exists($uploadPath)) {
        mkdir($uploadPath, 0755, true);
    }
    
    $destination = $uploadPath . '/' . $filename;
    
    if (move_uploaded_file($file['tmp_name'], $destination)) {
        $url = UPLOAD_URL . '/' . $yearMonth . '/' . $filename;
        
        echo json_encode([
            'success' => true,
            'data' => [
                'url' => $url,
                'filename' => $filename
            ]
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'message' => 'Failed to save file'
        ]);
    }
}