<?php
/**
 * Admin Categories Management
 */

function createCategory() {
    $user = JWT::verify();
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (empty($input['name'])) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Category name is required'
        ]);
        return;
    }
    
    $db = Database::getInstance()->getConnection();
    
    $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $input['name']), '-'));
    
    $query = "INSERT INTO categories (name, slug, description) 
              VALUES (:name, :slug, :description)";
    
    try {
        $stmt = $db->prepare($query);
        $stmt->execute([
            ':name' => $input['name'],
            ':slug' => $slug,
            ':description' => $input['description'] ?? null
        ]);
        
        echo json_encode([
            'success' => true,
            'data' => [
                'id' => $db->lastInsertId(),
                'slug' => $slug
            ],
            'message' => 'Category created successfully'
        ]);
    } catch (PDOException $e) {
        if ($e->getCode() == 23000) {
            http_response_code(400);
            echo json_encode([
                'success' => false,
                'message' => 'Category already exists'
            ]);
        } else {
            throw $e;
        }
    }
}